package com.jonohennessy {
	import flash.display.*;
	import flash.events.*;
	import flash.text.*;
	import flash.net.*;
	
	public class ElementPopup extends Sprite {
		private var xml:XML;
		
		private var thumbnailArray:Array= [];
		private var largeArray:Array = [];
		private var colourArray:Array = [];
		private var eyeSize:String;
		private var bridgeSize:String;
		private var modelNumber:String;
		
		private var thumbnailContainer:Sprite;
		private const thumbnailCenterX:int = 450;
		private const thumbnailCenterY:int = 390;

		private var background:Sprite;

		public var backButton:SimpleButton;
		public var modelText:TextField;
		public var eyeSizeText:TextField;
		public var bridgeSizeText:TextField;

		private var browser:ElementBrowser;

		private var imageContainer:Sprite;
		private var imageLoader:Loader;
		private const imageCenterX:int = 135;
		private const imageCenterY:int = 110;
		
		//public var modelText:TextField;
		
		public function ElementPopup(xml:XML, browser:ElementBrowser) {
			this.xml = xml;
			this.browser = browser;
			processXML();
			
			// Create thumbs
			generateThumbnails();
			
			// Back button
			backButton.addEventListener(MouseEvent.CLICK, backClick);

			// Default load first image
			loadImage(0);
		}
		
		private function processXML():void {
			modelNumber = xml.@model;
			trace(modelNumber);
			eyeSize = xml.@eyeSize;
			bridgeSize = xml.@bridgeSize;
			for each (var colour:XML in xml.*) {
				thumbnailArray.push(colour.THUMBNAIL);
				largeArray.push(colour.LARGE);
				colourArray.push(colour.@colourNumber);
				
				// Debug code
				//trace("colour id " + colour.@colourNumber + " thumb url: " + colour.THUMBNAIL + " full url: " + colour.LARGE);
			}
			
			trace("first entry is: " + colourArray[0]);
		}
		
		private function generateThumbnails():void {
			thumbnailContainer = new Sprite();
			addChild(thumbnailContainer);
			thumbnailContainer.y = thumbnailCenterY;
			// If only one thumb, load it dead middle - based on 120px width
			if (thumbnailArray.length == 1) {
				thumbnailContainer.x = thumbnailCenterX - 120 / 2;
			// If 2-6 thumbs, they are being drawn on one line, space them based on 140 width
			} else if (thumbnailArray.length <= 6) {
				thumbnailContainer.x = thumbnailCenterX - (140 * thumbnailArray.length)/2 + 10; // +10 is a half of the extra padding, to help the first entry
			// If >6, space them based on a fixed number of 4 max per row
			} else {
				thumbnailContainer.x = thumbnailCenterX - (140 * 4)/2 + 10; // +10 is a half of the extra padding, to help the first entry
			}
			
			for (var i:int = 0; i < thumbnailArray.length; i++) {
				var thumbnail:ElementThumbnail = new ElementThumbnail("glasses/"+thumbnailArray[i], i);
				thumbnailContainer.addChild(thumbnail);
				// If one thumb only, set it to 0
				if (thumbnailArray.length == 1) {
					thumbnail.x = i * 120;
				// If 2-6 thumbs, put them across one row - add 20px to each width (so set on 140 intervals, not 120)
				} else if (thumbnailArray.length <= 6) {
					thumbnail.x = i * 140;
				// If >6, split them into multiple rows of 4 a line
				} else {
					// Test as 4 a line
					var row:int = Math.floor(i/4);
					thumbnail.y = row * 50;
					thumbnail.x = (i - row * 4) * 140;
				}
				thumbnail.addEventListener(MouseEvent.CLICK, thumbnailClick);
				thumbnail.buttonMode = true;
			}
		}
		
		// On click of the thumbnails
		private function thumbnailClick(e:MouseEvent):void {
			loadImage(e.target.getID());
		}
		
		// Loading the main image
		private function loadImage(id:int):void {
			trace("i want to load " + id);
			
			// Set the text first
			modelText.htmlText = "<b>" + modelNumber + "</b> - " + colourArray[id];
			eyeSizeText.text = "Size " + eyeSize;
			bridgeSizeText.text = bridgeSize;
			
			// Load the image in
			var imageRequest:URLRequest = new URLRequest("glasses/" + largeArray[id]);
			imageLoader = new Loader();
			imageLoader.contentLoaderInfo.addEventListener(Event.INIT, displayImage);
			imageLoader.load(imageRequest);
		}
		
		// Placing the main image (called on initialisation of load)
		private function displayImage(e:Event):void {
			imageContainer = new Sprite();
			addChild(imageContainer);
			imageContainer.x = imageCenterX;
			imageContainer.y = imageCenterY;
			imageContainer.addChild(imageLoader.content);
		}
		
		// Click of the back button
		private function backClick(e:MouseEvent):void {
			trace("back clicked");
			dispose();
			browser.closePopup();
		}
		
		// The kill function - kill anything thats active, eg listeners
		public function dispose():void {
			backButton.removeEventListener(MouseEvent.CLICK, backClick);
		}
	}
}